#ifndef __Host__
#define __Host__

/**
 * @file Host.h
 * @brief Single include for the host package
 *
 * @date 23/08/2004
 * @author Paul Chana
 * @version 1.0.0 Initial version
 *
 * @note All contents of this source code are copyright 2005 Exp Digital Uk.\n
 * This source file is covered by the licence conditions of the Infinity API. You should have recieved a copy\n
 * with the source code. If you didnt, please refer to http://www.expdigital.co.uk
 * All content is the Intellectual property of Exp Digital Uk.\n
 * Certain sections of this code may come from other sources. They are credited where applicable.\n
 * If you have comments, suggestions or bug reports please visit http://support.expdigital.co.uk
 *
 * $Id: Host.h,v 1.4 2007/02/08 21:06:44 paul Exp $
 */
/**
 * @namespace Exponent::Host
 * @brief Host specific functionality
 *
 * All the information that you could want to know about your host is accessible through this namespace.\n
 * Also contained are the generic entry points to the API system
 */

#include "CApplication.hpp"
#include "CClipBoard.hpp"
#include "CDLLLoader.hpp"
#include "CDisplayInformation.hpp"
#include "CDriveInformation.hpp"
#include "CEmail.hpp"
#include "CEndian.hpp"
#include "CFPUInformation.hpp"
#include "CFileInformation.hpp"
#include "CFileManager.hpp"
#include "CRegistry.hpp"
#include "CRegistryInfo.hpp"
#include "CSystemInformation.hpp"
#include "CTime.hpp"
#include "SSystemInformation.hpp"

//	===========================================================================

#ifndef EXPONENT_COMPACT_BUILD
	using namespace Exponent::Host;
#endif

#endif	// End of Host.h